<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="UTF-8" />
        <meta http-equiv="X-UA-Compatible" content="IE=edge" />
        <meta name="viewport" content="width=device-width, initial-scale=1.0" />
        <link rel="icon" href="images/favicon.ico" />
        <link
            rel="stylesheet"
            href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.1/css/all.min.css"
            integrity="sha512-KfkfwYDsLkIlwQp6LFnl8zNdLGxu9YAA1QvwINks4PhcElQSvqcyVLLD9aMhXd13uQjoXtEKNosOWaZqXgel0g=="
            crossorigin="anonymous"
            referrerpolicy="no-referrer"
        />



         
        <script src="//unpkg.com/alpinejs" defer></script>



        <script src="https://cdn.tailwindcss.com"></script> 
        <script>
            tailwind.config = {
                theme: {
                    extend: {
                        colors: {
                            laravel: "#FFAA33",
                        },
                    },
                },
            };
        </script>
        <title>Hot | Find Escorts</title>
    </head>
    <body class="mb-48">
        <nav class="flex justify-between items-center mb-4">
            <a href="/"
                ><img class="w-24" src="<?php echo e(asset('images/logo.png')); ?>" alt="" class="logo"
            /></a>
            <ul class="flex space-x-6 mr-6 text-lg">
                
                <?php if(auth()->guard()->check()): ?>  

                    <li>
                        <span class="font-bold uppercase">
                            Welcome <?php echo e(auth()->user()->name); ?>

                        </span>
                    </li>
                    <li>
                        <a href="/listings/manage" class="hover:text-laravel"
                            ><i class="fa-solid fa-gear"></i>
                            Manage Listings</a
                        >
                    </li>
                    
                    <li>
                        <form class="inline" method="POST" action="/logout">
                            <?php echo csrf_field(); ?>

                            <button type="submit">
                                <i class="fa-solid fa-door-closed"></i> Logout
                            </button>
                        </form>
                    </li>

                <?php else: ?> 
                    
                    <li>
                        <a href="/register" class="hover:text-laravel"
                            ><i class="fa-solid fa-user-plus"></i> Register</a
                        >
                    </li>
                    <li>
                        <a href="/login" class="hover:text-laravel"
                            ><i class="fa-solid fa-arrow-right-to-bracket"></i>
                            Login</a
                        >
                    </li>

                <?php endif; ?>

            </ul>
        </nav>


    
        
        <main>

            <?php echo e($slot); ?>

            

        </main>
        



        <footer
            class="fixed bottom-0 left-0 w-full flex items-center justify-start font-bold bg-laravel text-white h-24 mt-24 opacity-90 md:justify-center"
        >
            <p class="ml-2">Copyright &copy; <?php echo e(date('Y')); ?>, All Rights reserved</p>

            <a
                href="/listings/create"
                class="absolute top-1/3 right-10 bg-blue-950 text-white py-2 px-5"
                >Post an Advert</a
            >
        </footer>

        
        <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.flash-message','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('flash-message'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>

    </body>
</html><?php /**PATH /home/alex-mari/Documents/job/resources/views/components/layout.blade.php ENDPATH**/ ?>